IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Verificacion_Saldos_Clientes') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.[CPJ_Verificacion_Saldos_Clientes]
END
GO

CREATE PROCEDURE [dbo].[CPJ_Verificacion_Saldos_Clientes]  @pJsonRecibido VARCHAR(8000)	 

AS

DECLARE 	@pFecha_Desde		DATETIME,
			@pFecha_Hasta		DATETIME


SET @pFecha_Desde				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Desde')),GETDATE())
SET @pFecha_Hasta				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJsonRecibido,'Fecha_Hasta')),GETDATE())

--VERSION: 10/02/2022
		select c.id_cliente,c.destinatario,cast(sum(c.imp_total*t.compromete_factura*c.cotizacion)  as decimal(14,2)) as Rescta
		Into #Verificacion
		from cbtes c, cbtes_tipos t
		where c.id_tipo_cbte = t.Id_Tipo_Cbte
		and compromete_factura in (1,-1)
		and c.Id_Estado_Cbte not in (0,3)
		and c.id_cliente >1
		and c.Id_Cond_Pago <> 1
		group by  c.id_cliente,c.destinatario

		ALTER TABLE #Verificacion ADD Deuda Decimal(14,2),Diferencia Decimal(14,2)
		UPDATE #Verificacion SET DEUDA = 0, DIFERENCIA = 0

		select c.id_cliente,c.destinatario,sum(c.imp_total*c.cotizacion) as recibos
		into #Recibos
		from cbtes c, cbtes_tipos t
		where c.id_tipo_cbte = t.Id_Tipo_Cbte
		and compromete_recibos in (1,-1)
		and c.Id_Estado_Cbte not in (0,3)
		and c.id_cliente > 1
		group by  c.id_cliente,c.destinatario


		select c.id_cliente,c.Destinatario,sum(t.importe*c.cotizacion) as importe, sum(t.saldo*c.cotizacion) as saldo
		Into #CtaCte
		from  clientes_ctacte t, Cbtes C
		where c.id_trans = t.id_trans
		and t.Id_Estado_Cbte not in (0,3)
		and c.id_cliente >1
		group by  c.id_cliente,c.Destinatario


		Update #Verificacion set Rescta = C.Rescta - R.Recibos from #Verificacion C, #Recibos R Where C.Id_Cliente = R.Id_Cliente

		Update #Verificacion set Deuda = R.Importe from #Verificacion C, #CtaCte R Where C.Id_Cliente = R.Id_Cliente

		Update #Verificacion set Diferencia = Rescta - Deuda  

		SELECT * FROM #Verificacion order by Destinatario

		DROP TABLE #Verificacion
		DROP TABLE #Recibos
		DROP TABLE #CtaCte


	--	CPJ_Verificacion_Saldos_Clientes '{}' 